include <mirrorconf3.scad>

msl=0.5;//[cm] mirror side length
mth=0.1;//[cm] mirror thickness
mrsc=mth/2;//[cm] mirror reflective surface center, where 0 means fully behind glass and 0.1 means top of glass

module mirpl(i){
    //place mirror support object into calculated location
    //input object should start with the target laser intersection at the origin
    // and any solid material at X<0, with the target reflection
    // in the YZ plane at X=0, with Z aligned to the main rotation axis and laser beam height
    rotate([0,0,mirror_ts[i]/num_mts*360]) translate([mirror_x[i],0,mirror_z[i]]) rotate([0,-mirror_a[i],0]) children();
}

module mirr(){
    for(i=[0:(num_mirrors-1)]){
        mirpl(i) translate([-mrsc,-msl/2,-msl/2]) cube([mth,msl,msl]);
    }
}

module supp(){
    sth=2;
    for(i=[0:(num_mirrors-15)]){
        mirpl(i) translate([-sth-mrsc,-msl/2,-msl/2]) cube([sth,msl,msl]);
    }
    for(i=[(num_mirrors-14):(num_mirrors-1)]){
        stj=(num_mirrors-i+1)*0.1;
        mirpl(i) translate([-stj-mrsc,-msl/2,-msl/2]) cube([stj,msl,msl]);
    }
    translate([0,0,18.5]) cylinder($fn=10,h=1.2,r1=0.3,r2=0.15);
}

module sneg(){
    gth=0.01;//[cm] glue thickness
    sth=2;
    stl=msl+0.02;//[cm] expanded mirror sides
    inwt=0.1;//[cm] support inner wall thickness
    stt=msl-2*inwt;
    stu=0.6;
    for(i=[0:(num_mirrors-1)]){
        mirpl(i) translate([-mrsc-gth,-stl/2,-stl/2]) cube([sth,stl,stl]);
        if((num_mirrors-i)>3){
            mirpl(i) translate([-mrsc-stu-inwt,-stt/2,-stt/2]) cube([stu,stt,stt]);
        }
    }
    translate([-sth-0.15,-stl/2,19.8]) cube([sth,stl,stl]);
}

module support_bars(){
    sbw=1; //support bar width
    sbl=12; //support bar length
    for(i=[0:60:359]){
        rotate([0,0,i]) translate([-sbw/2,0,0]) cube([sbw,sbl,swth]);
        rotate([0,0,i]) rotate([0,-90,0]) translate([0,0,-swth/2]) cube([sbw,sbl,swth]);  
    }
}

cr=12;//[cm] bottom cone radius
ct=-0.5;//[cm] cone bottom translation
ch=tan(180-laser_angle)*cr;
wth=0.05;//[cm] cone wall thickness
dtd=wth/cos(180-laser_angle);
difference(){
   union(){
       supp();
       translate([0,0,ct]) cylinder(h=ch, r1=cr, r2=0);
   }
   translate([0,0,-dtd+ct]) cylinder(h=ch, r1=cr, r2=0);
   sneg();
}

swth=0.1;//[cm] support wall thickness
translate([0,0,ct])difference(){cylinder(h=swth, r=cr-wth); translate([0,0,-0.1]) cylinder(h=swth+0.2, r=cr-1);}
ich=18.4;//[cm] inner cylinder height
translate([0,0,ct])difference(){cylinder($fn=10,h=ich, r=1); translate([0,0,-0.1]) cylinder($fn=10,h=ich+0.2, r=1-swth);}

translate([0,0,ct]) difference(){ 
    union(){ 
        intersection(){
            support_bars();
            cylinder(h=ch, r1=cr, r2=0);
        }
        cylinder($fn=20,h=swth,r=1.25); 
    }
    translate([0,0,-0.01])cylinder($fn=20,h=swth+0.02,r=0.25); 
}